Attribute VB_Name = "Module1"
Option Explicit

Public IniPathParGen As String
Public IniPath As String


'Type per settare i parametri pubblici dell'applicazione
   Private Type gtAppParam
      gAlwaysShow As Boolean
      gStepByStep As Boolean
      gErrList() As String
      gInTEST As Boolean
      gComandataChiusura As Boolean
      gChiusuraObbligatoria As Boolean
      gPrimoRoot As String 'E' la cartella di PRIMO
      gExternalLOCK As Boolean 'Se TRUE significa che non devo aggiornare il file ext.ini e relativa immagine della cartella "...PRIMO\Files\Ext"
   End Type
   Public AppParam As gtAppParam

'Type per la gestione degli Errori
   Private Type ErrorLoad
      eErrEnabled As Boolean
      eErrText As String
      eErrRoutine As String
   End Type
   Public tErrorLoad As ErrorLoad

'Type contenente i dati dell'applicazione
   Private Type datiApp
      aPrimoExe As String
      aFolderInstall As String
      aDowloadPatch As String
      aDowloadExtra As String
      aDowloadMarketing As String
      aFolderPrimoWeb As String
      aFolderUpdaterWeb As String
      aFileNamePatch As String
      'aFolderVideoGuide As String
      'aFolderExternal As String
   End Type
   Public tDatiApp As datiApp

'Type contenente i dati del Cliente
   Private Type datiCliente
      cIdCliente As String
         '- - - - -
      cAnnoPreced As String
      cNumFT_V_AP As Long 'Fatture Vendita Anno Precedente
      cNumNC_V_AP As Long 'Note Credito Anno Precedente
      cNumRC_V_AP As Long 'Ricevute Anno Precedente
      cNumCO_V_AP As Long 'Corrispettivi Anno Precedente
      cNumFT_A_AP As Long 'Fatture di Acquisto Anno Precedente
         '- - - - -
      cAnnoCorren As String
      cNumFT_V_AC As Long 'Fatture Vendita Anno Corrente
      cNumNC_V_AC As Long 'Note Credito Anno Corrente
      cNumRC_V_AC As Long 'Ricevute Anno Corrente
      cNumCO_V_AC As Long 'Corrispettivi Anno Corrente
      cNumFT_A_AC As Long 'Fatture di Acquisto Anno Corrente
   End Type
   Public tDatiCliente As datiCliente
   

'Type contenente i dati della Licenza del Cliente
   Private Type mtLicenza
      lScadenza As String
      lScadeGG As Integer
      lGGExtraScadenza As Integer
      lTipo As enumTipoLicenza
      lModuloWeb As String
      lModuloFE As String
   End Type
   Public tLicenza As mtLicenza

   'Enumeratore per il Tipo di Licenza
      Public Enum enumTipoLicenza
         eLic_Acquisto = 1
         eLic_Noleggio = 2
      End Enum


'Type contenente le News
   Private Type mtNews
      From As String
      To As String
      Title As String
      Body1 As String
      Body2 As String
   End Type
   Public tNews As mtNews

'Type contenente le info sul Marketing
   Private Type mtMarketing
      fileJGP() As String
      fileCNF() As String
      linkExt() As String
      'Title() As String
   End Type
   Public tMarketing As mtMarketing


'Public ConnessioneGenerale As ADODB.Connection  'punta all'mdb GENERALE che si trova sotto la directory "[App.path]&\DB\Generale.mdb"

'Private Declare Function ReleaseCapture Lib "user32" () As Long 'per risolvere il problema dell'errore di RUN-TIME 400 (chiamata form modali)

'Constanti per spostare la Splash form che non ha la barra di windows nella finestra
Public Declare Function ReleaseCapture Lib "user32" () As Long
Public Const WM_NCLBUTTONDOWN = &HA1
Public Const HTCAPTION = 2
Public Const EM_GETLINECOUNT = &HBA

Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hWnd As Long, _
ByVal wMsg As Long, ByVal WParam As Long, lParam As Any) As Long

'Costante x la conversione del Path DOS
Public Const SW_SHOWNORMAL As Long = 1

'Per aprire i file in automatico
Declare Function ShellExecute Lib "shell32.dll" _
Alias "ShellExecuteA" _
(ByVal hWnd As Long, ByVal lpOperation As String, _
ByVal lpFile As String, ByVal lpParameters As String, _
ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long


'Per leggere nel file INI
Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" _
                  (ByVal lpApplicationName As String, _
                   ByVal lpKeyName As Any, _
                   ByVal lpDefault As String, _
                   ByVal lpReturnedString As String, _
                   ByVal nSize As Long, _
                   ByVal lpFileName As String) _
                  As Long

Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" _
                  (ByVal lpApplicationName As String, _
                   ByVal lpKeyName As Any, _
                   ByVal lpString As Any, _
                   ByVal lpFileName As String) _
                  As Long


Public Site As String

Public Const CB_GETDROPPEDSTATE As Long = &H157
Public Const CB_SHOWDROPDOWN As Long = &H14F

Declare Function SendMessageAsLong _
Lib "user32" _
Alias "SendMessageA" ( _
ByVal hWnd As Long, _
ByVal wMsg As Long, _
ByVal WParam As Long, _
ByVal lParam As Long) As Long

'****  DICHIARAZIONI PER I Form SEMPRE IN PRIMO PIANO   ****
Private Declare Function SetWindowPos Lib "user32" (ByVal hWnd As Long, _
                                                    ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, _
                                                    ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Const SWP_NOSIZE = &H1
Const SWP_NOMOVE = &H2
Const SWP_SHOWWINDOW = &H40
Const HWND_NOTOPMOST = -2
Const HWND_TOPMOST = -1



'http://www.primosoftware.it/assistenza.php?name= &rif= &phone= &citta= &email=  &id= &richiesta= &software= &contratto= &programma= &messaggio=

Sub Main()
   
   
   If App.PrevInstance Then End
   
   'Setto le variabili CSS
      Call SetCSSApp
      
   'Path dei file cnf
      IniPath = App.Path + "\ParUpdater.CNF"
   
   
   'Se true significa che si deve aprire SEMPRE (serve soprattuto in sviluppo)
      AppParam.gAlwaysShow = (ReadINI("PARAMETRI", "ALWAYS_SHOW", IniPath) = "T")
   
   
   Call MsgInLogFile(String(60, "~"), "")
               
               
   'Questo PARAMETRO comanda su tutte le altre configurazioni
      'If Len(Trim(IniPathParGen)) = 0 Then
         'Controllo se c' un ParGen.CNF nel App.Path e nel qual caso comanda
         If VerificaEsistenzaFile(App.Path & "\ParGen.cnf") Then
            IniPathParGen = App.Path & "\ParGen.cnf"
         Else
            IniPathParGen = App.Path & "\..\..\ParGen.cnf"
         End If
      'End If

   'Se arriva qui controllo che il ParGen esista. In caso contrario ESCO
      If VerificaEsistenzaFile(IniPathParGen) = False Then
         Call MsgInLogFile("Sub 'MAIN' - File di configurazione non trovato! (" & IniPathParGen & ")", "SubMAIN", True, True)
         If Not AppParam.gAlwaysShow Then Exit Sub
      End If
      
      
      'Imposto il PATH dell'eseguibile di PRIMO
      'Dim AppParam.gPrimoRoot As String
         AppParam.gPrimoRoot = ReadINI("PATCH_UPDATER", "PATH_PRIMO", IniPathParGen)
         If Len(Trim(AppParam.gPrimoRoot)) > 0 Then
            tDatiApp.aPrimoExe = AppParam.gPrimoRoot & "\Primo.exe"
            tDatiApp.aFolderInstall = AppParam.gPrimoRoot
         Else
            AppParam.gPrimoRoot = App.Path & "\..\.."
            tDatiApp.aPrimoExe = App.Path & "\..\..\Primo.exe"
            tDatiApp.aFolderInstall = App.Path & "\..\.."
         End If
      
      'Se arriva qui controllo che il ParGen esista. In caso contrario ESCO
         If VerificaEsistenzaFile(tDatiApp.aPrimoExe) = False Then
            Call MsgInLogFile("Path  di PRIMO.EXE non valido! (" & tDatiApp.aPrimoExe & ")", "SubMAIN", True, True)
            If Not AppParam.gAlwaysShow Then Exit Sub
         End If
            
           
      'Altri parametri
         AppParam.gInTEST = (ReadINI("PATCH_UPDATER", "TEST", IniPathParGen) = "T")
         AppParam.gExternalLOCK = (ReadINI("GRAFICA", "EXT_LOCK", IniPathParGen) = "T")
            
            
   'Cancello eventuali file di log dell'anno precedente in modo da non creare file spazzatura
      Call KillaFile(App.Path & "\Log\LogUpdater_" & (Year(Date) - 1) & "." & Format(Date, "mm") & ".cnf")
   
   'Apro la FormMAIN
      'Call SetAlwaysOnTopMode(FormMAIN)
      FormMAIN.Hide

End Sub

'Public Sub ApriConnessione()
'   'Qui mi collego al Database
'   Set ConnessioneGenerale = New ADODB.Connection
'
'   ConnessioneGenerale.ConnectionString = "Provider = Microsoft.Jet.OLEDB.4.0;Data Source =" & App.Path & "\Abilitazioni.mdb;Jet OLEDB:Database Password='';"
'   ConnessioneGenerale.Open
'   ConnessioneGenerale.CursorLocation = adUseClient
'End Sub
'Public Sub ChiudiConnessione()
'   On Error Resume Next
'   ConnessioneGenerale.Close
'End Sub

Public Function NonNullo(Argomento As Variant, Optional Numerico As Boolean) As Variant
   If IsNull(Argomento) Then
      If Numerico = False Then
         NonNullo = ""
      Else
         NonNullo = "0"
      End If
   Else
      If Numerico = False Then
         NonNullo = Argomento
      Else
         If IsNumeric(Argomento) = True Then 'Qui faccio un ulteriore controllo se il valore deve essere numerico
            NonNullo = Argomento
         Else
            NonNullo = "0"
         End If
      End If
   End If
End Function


Public Function DataOraSQL(ByVal strData As String, Optional StrOra As Boolean, _
                           Optional OraDB As String, Optional DataConOra As Boolean) As String

   Dim DataEora As String
   Dim vOra As String
   Dim vDat As String

'ACCESS
'   If gTipoDB = 0 Then
      If StrOra Then
         'DataEora = (Mid(StrData, 4, 2) & "/" & Left(StrData, 2) & "/" & Right(StrData, 2)) & " " & Str(Hour(Time)) & ":" & Trim(Str(Minute(Time))) & ":" & Trim(Str(Second(Time)))
         DataEora = Format(strData, "hh:mm")
         DataEora = Replace(strData, ".", ":")
      Else
         vDat = Format(strData, "mm/dd/yyyy")
         If DataConOra = True Then
            vOra = Format(strData, "hh:nn:ss")
         Else
            vOra = Format(OraDB, "hh:nn:ss")
         End If
         vOra = Replace(vOra, ".", ":")
         DataEora = vDat & " " & vOra
         'DataEora = Trim((Mid(StrData, 4, 2)) & "/" & Trim(Left(StrData, 2)) & "/" & Trim(Right(StrData, 2)))
      End If
   
      DataOraSQL = "#" & Trim(DataEora) & "#"

'SQL
'   Else
'      vDat = Format(strData, "yyyy/mm/dd")
'      vOra = OraDB
'
'      If DataConOra = True Then
'         DataOraSQL = "CONVERT(DATETIME, '" & vDat & "',102)"
'      Else
'         DataOraSQL = "CONVERT(DATETIME, '" & vDat & " " & vOra & "', 102)"
'      End If
'   End If
   
End Function


Public Sub MoveFormByDragDrop(MouseButton As Integer, objForm As Form)
   If MouseButton = vbLeftButton Then
       ReleaseCapture
       SendMessage objForm.hWnd, WM_NCLBUTTONDOWN, HTCAPTION, 0&
   End If
End Sub


Public Sub OpenWebPage(pForm As Form, pIndirizzo As String, Optional pSkype As Boolean)
   Dim success As Integer
   
   If Len(Trim(pIndirizzo)) > 0 Then
      
      If pSkype = False Then
         If Trim(pIndirizzo) = "http://www." Or Trim(pIndirizzo) = "" Then ' I have the pIndirizzo set to http://www.
             'MsgBox "Inserire un indirizzo web", vbCritical, "Mancanza di Dati"
             Exit Sub
         ElseIf (Left(Trim(pIndirizzo), 11) = "http://www.") Or (Left(Trim(pIndirizzo), 12) = "https://www.") Then
             Site = Trim(pIndirizzo)
         ElseIf Left(Trim(pIndirizzo), 4) = "www." Then
             Site = "http://" & Trim(pIndirizzo)
         Else
             Site = "http://www." & Trim(pIndirizzo)
         End If
         success% = ShellToBrowser(pForm, Site, SW_SHOWNORMAL)
      Else
         success% = ShellToBrowser(pForm, "skype:" & pIndirizzo & "?chat", SW_SHOWNORMAL)
      End If
      
   End If
End Sub

Function ShellToBrowser%(Frm As Form, ByVal URL$, ByVal WindowStyle%)
'FUNZIONE PER APRIRE IL SITO INTERNET CLICCANDO SU UN LINK
   Dim api%
   
   api% = ShellExecute(Frm.hWnd, "open", URL$, "", App.Path, WindowStyle%)
   'Intercetta il valore restituito
   If api% < 31 Then
   'codice dell'errore - guarda l'help delle api per maggiori informazioni
       MsgBox App.Title & " ha un problema nel far avviare il Web Browser." & vbNewLine & _
              "Controllare che sia installato correttamente.(Error" & Format$(api%) & ")", msg_Critical, "Browser Non Disponibile"
       ShellToBrowser% = False
   ElseIf api% = 32 Then
   'nessun file associato
       MsgBox App.Title & " non riesce a trovare un file associato a " & URL$ & " sul sistema." & vbNewLine & _
              "Controllare che il browser sia installato correttamente e associato con questo tipo di file.", msg_Critical, "Browser Non Disponibile"
       ShellToBrowser% = False
   Else
       'E' al lavoro!
       ShellToBrowser% = True
   End If
End Function

Public Function CodificaStringaURL(pStr As String) As String
   'questa funzione restituisce la stringa codificata per l'URL
   Dim i As Integer
   Dim vStrConv As String
   
   vStrConv = ""
   
   For i = 1 To Len(pStr)
   
      vStrConv = vStrConv & CodificaCharURL(Mid(pStr, i, 1))
      
   Next i
   
   CodificaStringaURL = vStrConv

End Function

Public Function CodificaCharURL(pChar As String) As String
   'questa funziona codifica il carattare nella simbologia adatta all'URL
   Dim vValChar As Integer
   
   vValChar = Asc(pChar)
   
   Select Case vValChar
   Case 48 To 57 'Numeri
      CodificaCharURL = pChar
      Exit Function
   
   Case 65 To 90 'Lettere MAIUSCOLE
      CodificaCharURL = pChar
      Exit Function
    
   Case 97 To 122 'lettere minuscole
      CodificaCharURL = pChar
      Exit Function
      
'Qui inizio con le codifiche
   Case 32  '  spazio
      CodificaCharURL = "%20"
      Exit Function
   
'Lettere accentate
   Case 224  '  
      CodificaCharURL = "%C3%A0"
      Exit Function
   Case 232  '  
      CodificaCharURL = "%C3%A8"
      Exit Function
   Case 233  '  
      CodificaCharURL = "%C3%A9"
      Exit Function
   Case 236  '  
      CodificaCharURL = "%C3%AC"
      Exit Function
   Case 242  '  
      CodificaCharURL = "%C3%B2"
      Exit Function
   Case 249  '  
      CodificaCharURL = "%C3%B9"
      Exit Function
   
'PIU' USATI
   Case 34  '  "
      CodificaCharURL = "%22"
      Exit Function
   Case 39  '  '
      CodificaCharURL = "%27"
      Exit Function
   Case 43  '  +
      CodificaCharURL = "%2B"
      Exit Function
   Case 44  '  ,
      CodificaCharURL = "%2C"
      Exit Function
   Case 45  '  -
      CodificaCharURL = "%2D"
      Exit Function
   Case 46  '  .
      CodificaCharURL = "%2E"
      Exit Function
   Case 47  '  /
      CodificaCharURL = "%2F"
      Exit Function
   Case 58  '  :
      CodificaCharURL = "%3A"
      Exit Function
   Case 59  '  ;
      CodificaCharURL = "%3B"
      Exit Function
   Case 63  '  ?
      CodificaCharURL = "%3F"
      Exit Function
   Case 64  '  @
      CodificaCharURL = "%40"
      Exit Function
   Case 37  '  %
      CodificaCharURL = "%25"
      Exit Function
   Case 38  '  &
      CodificaCharURL = "%26"
      Exit Function
   Case 40  '  (
      CodificaCharURL = "%28"
      Exit Function
   Case 41  '  )
      CodificaCharURL = "%29"
      Exit Function
   Case 42  '  *
      CodificaCharURL = "%2A"
      Exit Function
   Case 128  '  
      CodificaCharURL = "%E2%82%AC"
      Exit Function
   Case 95  ' _ '
      CodificaCharURL = "%5F"
      Exit Function

'MENO USATI
   Case 60  '  <
      CodificaCharURL = "%3C"
      Exit Function
   Case 61  '  =
      CodificaCharURL = "%3D"
      Exit Function
   Case 62  '  >
      CodificaCharURL = "%3E"
      Exit Function
   Case 91  '  [
      CodificaCharURL = "%5B"
      Exit Function
   Case 92  '  \
      CodificaCharURL = "%5C"
      Exit Function
   Case 93  '  ]
      CodificaCharURL = "%5D"
      Exit Function
   Case 94  '  ^
      CodificaCharURL = "%5E"
      Exit Function
   Case 123  '  {
      CodificaCharURL = "%7B"
      Exit Function
   Case 124  '  |
      CodificaCharURL = "%7C"
      Exit Function
   Case 125  '  }
      CodificaCharURL = "%7D"
      Exit Function
   Case 126  '  ~
      CodificaCharURL = "%7E"
      Exit Function
   Case 35  '  #
      CodificaCharURL = "%23"
      Exit Function
   
   Case Else
      CodificaCharURL = pChar
   End Select
' Eccco la lista dei caratteri che necessitano di una codifica particolare :
' Carattere Codifica URL
' Tabulazione %09
' Spazio %20
' " %22
' # %23
' % %25
' & %26
' ( %28
' ) %29
' + %2B
' , %2C
' . %2E
' / %2F
' : %3A
' ; %3B
' < %3C
' = %3D
' > %3E
' ? %3F
' @ %40
' [ %5B
' \ %5C
' ] %5D
' ^ %5E
' ' %60
' { %7B
' | %7C
' } %7D
' ~ %7E

End Function

Public Sub SetAlwaysOnTopMode(hWndOrForm As Variant, Optional ByVal OnTop As Boolean = True)
   Dim hWnd As Long
   ' get the hWnd of the form to be move on top
   If VarType(hWndOrForm) = vbLong Then
      hWnd = hWndOrForm
   Else
      hWnd = hWndOrForm.hWnd
   End If
   SetWindowPos hWnd, IIf(OnTop, HWND_TOPMOST, HWND_NOTOPMOST), 0, 0, 0, 0, _
   SWP_NOMOVE Or SWP_NOSIZE Or SWP_SHOWWINDOW
End Sub


Public Function CorreggiEmail(prEmail As String) As String
   'questa funzione verifica quanti indirizzi email ci sono e ne controlla la validit
   Dim vConta As Byte
   Dim vEmail() As String
   Dim vTst As String
   Dim vNewMail As String
   Dim i As Byte
   
   If Len(Trim(prEmail)) = 0 Then Exit Function
   
   vTst = Trim(prEmail)
    
   'conto quante ";" ci sono
   vConta = Len(vTst) - Len(Replace(vTst, ";", ""))
   
   'splitto la stringa sul carattere ";"
   If vConta = 0 Then vConta = 1
   Erase vEmail
   ReDim vEmail(vConta - 1)
   vEmail = Split(Trim(prEmail), ";")
   
   For i = 0 To UBound(vEmail)
      vTst = Trim(LCase(vEmail(i)))
      
      If Len(vTst) > 0 Then
         If ControllaValiditaEmail(vTst) Then
            If Len(vNewMail) = 0 Then
               vNewMail = vTst
            Else
               vNewMail = vNewMail & "; " & vTst
            End If
         Else
            CorreggiEmail = False
            Exit Function
         End If
      End If
   Next i
   
   'se arriva qui  tutto OK!
   prEmail = vNewMail
   CorreggiEmail = True
End Function

Public Function ControllaValiditaEmail(pEmail As String) As Boolean
   Dim vPos As Integer
   
   ControllaValiditaEmail = False
   
   'Qui espondo tutte le varie possibilit che possano rendere nullo un indirizzo email
      If InStr(pEmail, "@") = 0 Then Exit Function 'manca la @hiocciola
      If InStr(pEmail, ".") = 0 Then Exit Function 'manca almeno un punto
      If Not (Len(pEmail) > 5) Then Exit Function  'la lunghezza della mail  inferiore a 6
   
      vPos = InStr(pEmail, "@")
      If vPos = 1 Then Exit Function   'la @hiocciola si trova al primo carattere
      If Not (vPos <= (Len(pEmail) - 4)) Then Exit Function 'la @hiocciola si trova in una posizione inferiore al quart'ultimo carattere
   
   'se arriva qui  tutto OK!
      ControllaValiditaEmail = True
End Function

Public Function ControlloCampiNumCel(Tasto As Integer)
   'Dim char As String       '(Valore del Tasto premuto, Contenuto del text)
   
'   'evito l'inserimento dello ZERO se c'e' solo uno ZERO
'   If ContenutoTXT = "0" And Tasto = 48 Then  'ancora 0
'      Tasto = 0
'      Controllo.SelStart = 1
'      Exit Function
'   End If

'************************************************************

   'char = Chr(tasto)
   If Tasto >= 48 And Tasto <= 57 Then 'Se >= di 0 e <= di 9
      Tasto = Tasto
   
   ElseIf Tasto = 44 Then    'VIRGOLA
      Tasto = Tasto

   ElseIf Tasto = 43 Then    '+
      Tasto = Tasto
   
   ElseIf Tasto = 8 Then    'se tasto cancella
      Tasto = Tasto

   Else
      Tasto = 0   'altrimenti non scrivo niente
   End If

End Function

Public Function CorreggiNumCell(pNumCel As String) As String
   'questa funzione pulisce il numero di cellulare eliminando eventuali SPAZI o CARATTERI NON Numerici _
    tranne l'eventuale '+' posizionato SOLO al primo carattere che fa parte del prefisso internazionale
   Dim vNewNum As String
   Dim vChar As String
   Dim i As Byte
      
   For i = 1 To Len(Trim(pNumCel))
      vChar = Mid(Trim(pNumCel), i, 1)
      If IsNumeric(vChar) Then
         vNewNum = vNewNum & vChar
      Else
         If (i = 1) And (vChar = "+") Then
            vNewNum = vNewNum & vChar
         End If
      End If
   Next i
   
   CorreggiNumCell = vNewNum
End Function

'Public Function ControllaNumCelValido(pNumCel As String) As Boolean
''in Questa funzione cerco di fare tutti controlli possibili affinch un numero di telefono sia valido e _
' conforme con le esigenze di invio
'
'   ControllaNumCelValido = True
'
'   'Qui controllo che il primo carattere sia un numero o al massimo il "+" del prefisso internazionale
'   If Mid(pNumCel, 1, 1) = "+" Then
'      If IsNumeric(Mid(pNumCel, 2)) = False Then
'         ControllaNumCelValido = False
'      Else
'         'nel caso sia un numero controllo che contenga un numero alla fine _
'          questo perche' se c'e' la virgola alla fine viene considerato comunque un numero
'         If IsNumeric(Mid(pNumCel, Len(pNumCel))) = False Then
'            ControllaNumCelValido = False
'         End If
'      End If
'
'   Else
'      If IsNumeric(pNumCel) = False Then
'         ControllaNumCelValido = False
'      Else
'         'nel caso sia un numero controllo che contenga un numero all'inizio _
'          questo perhce' se c'e' il "-" alla fine viene considerato comunque un numero
'         If IsNumeric(Mid(pNumCel, 1, 1)) = False Then
'            ControllaNumCelValido = False
'         End If
'         'nel caso sia un numero controllo che contenga un numero alla fine _
'          questo perhce' se c'e' la virgola alla fine viene considerato comunque un numero
'         If IsNumeric(Mid(pNumCel, Len(pNumCel))) = False Then
'            ControllaNumCelValido = False
'         End If
'      End If
'   End If
'
'End Function

'Funzione per leggere nel file INI
Public Function ReadINI(ByVal AppName As String, KeyName As String, Filename As String) As String
   Dim INIreturn As String
        
   INIreturn = String(255, Chr(0))
   ReadINI = Left(INIreturn, GetPrivateProfileString(AppName, KeyName, "", INIreturn, _
             Len(INIreturn), Filename))
End Function
'Funzione per scrivere nel file INI
Public Sub WriteINI(ByVal AppName As String, KeyName As String, NewString As String, Filename As String)
   Dim Flag As Integer
        
    Flag = WritePrivateProfileString(AppName, KeyName, NewString, Filename)
End Sub


Public Sub MsgInLogFile(Msg As String, pNomeFunzione As String, Optional pErrore As Boolean, Optional pDaSubMain As Boolean)   ', Optional pNomeLog As String, Optional pNuovoFile As Boolean)
   'se il parametro pNuovoFile  compilato significa che il file  diverso dallo standard

   Dim NumFile As Integer 'per aprire il file di esecuzioni(LOG)
   Dim vStrRec As String
   Dim vNomeFile As String
   
   On Error Resume Next
   
   
   vNomeFile = "LogUpdater_" & Year(Date) & "." & Format(Date, "mm") & ".cnf"
      
      
   Call VerificaEsistenzaPathCartella(App.Path & "\Log")
   
   
   If pErrore Then
      Msg = "ERRORE! -> " & Msg
   End If
   
   If AppParam.gAlwaysShow Then
      Call AddArrayElement(AppParam.gErrList, Msg)
   End If
   
   NumFile = FreeFile
      
   'Apro il file LOG
   Open App.Path & "\Log\" & vNomeFile For Append As #NumFile     'CREO IL FILE
      
      'Stampo il messaggio (la riga!)
      vStrRec = Format(Date, "yyyy/mm/dd") & "|" & _
                Format(Now, "hh:nn:ss") '& "|" & _
                pub_CodUtente
      
      vStrRec = vStrRec & "|" & Replace(Msg, Chr(13) + Chr(10), "")
      vStrRec = vStrRec & "|" & pNomeFunzione
      vStrRec = vStrRec & "|"
      
      Print #NumFile, vStrRec
      '+{榦ӱ=53?+jV+uY}4A65?AGT6A ???
      
      'STRUTTURA STRINGA : _
      DATA SISTEMA | ORA SISTEMA | CODICE UTENTE | STRINGA SQL | NOME FORM DI ESECUZIONE | CARATTERE DI FINE RIGA ()
      
   'Chiudo il file di LOG
   Close #NumFile
      
   'Questa istuzione mi serve per azzerare eventuali errori che possono verificarsi. In particolarte quando il comando _
    arriva da una form Modale l'istruzione MDIForm1.ActiveForm.Name genera l'errore 91
   On Error GoTo 0
         
End Sub


Public Function VerificaEsistenzaFile(pPathFile As String) As Boolean
   Dim MyFile As String
            
   'restituisce una stringa vuota se la cartella non esiste
   MyFile = Dir(pPathFile, vbNormal)
   If Len(Trim(MyFile)) = 0 Then
      'Il file non esiste
      VerificaEsistenzaFile = False
   Else
      'Il file esiste
      VerificaEsistenzaFile = True
   End If
End Function

Public Sub VerificaEsistenzaPathCartella(pPathCartella As String, Optional pSoloControllo As Boolean, Optional prEsistenza As Boolean)
   'Questa sub serve per controllare l'esistenza di una cartella e se non esiste la crea _
    salvo che il parametro pSoloControllo non sia TRUE. In questo caso effettua SOLO il controllo. _
    L'esito dell'esistenza  passato al parametro di ritorno prEsistenza (questo l'ho fatto perch _
    non ho voluto trasformare la Sub in Funzione perch gi usata all'interno del programma)
   
   Dim MyFolder As String
   
   'restituisce una stringa vuota se la cartella non esiste
   MyFolder = Dir(pPathCartella, vbDirectory)
   If Len(Trim(MyFolder)) = 0 Then
   'crea la cartella
      If pSoloControllo = False Then MkDir pPathCartella
      prEsistenza = False
   Else
      prEsistenza = True
   End If

End Sub


Public Sub KillaFile(pPathFile As String)
'QUESTA FUNZIONE PROVVEDE A CANCELLARE IL FILE PASSATO COME PARAMETRO "pPathFile"
   Dim vTentativi As Byte
 
   On Error GoTo GestErr
   
   vTentativi = 0
   
riprova:
   Kill pPathFile

   
GestErr:
   If err.Number = 53 Then
      Resume Next
   ElseIf err.Number <> 0 Then
      If vTentativi < 2 Then
         vTentativi = vTentativi + 1
         'Call PausaProgram(2)
         On Error GoTo 0
         GoTo riprova
      Else
         MsgBox err.Number & " - " & err.Description, vbCritical
      End If
   End If
   On Error GoTo 0
   
End Sub



Public Function GetNomeFile(PathFile As String) As String
'questa routine serve per recuperare da un path SOLO il nome del file
   Dim Pos As Byte
   
   Pos = InStrRev(PathFile, "\")
   GetNomeFile = Mid(PathFile, Pos + 1)
End Function

Public Function GetPathFile(PathFile As String) As String
'questa routine serve per recuperare da un path SOLO il Path della cartella escludendo il nome del file
   Dim Pos As Byte
   
   Pos = InStrRev(PathFile, "\")
   GetPathFile = Mid(PathFile, 1, Pos)
End Function

Public Function VerificaArrayInizializzato(v_Arr As Variant) As Boolean
   'Questa funzione mi restituisce TRUE se l'array  stato inizializzato
   On Local Error GoTo GestErr
   
   If (LBound(v_Arr) <= UBound(v_Arr)) Then VerificaArrayInizializzato = True

GestErr:
   
End Function

Public Function AddArrayElement(pArray As Variant, pElement As String) As String() ', Optional pSecondoElement As String) As String()
'Questa funzione richieder, per funzionare, di due argomenti: l'array su cui operare e l'elemento da aggiungere in coda.

  Dim NewArrSize As Integer
  
  ' Verifico se pArray  una array
   'If IsArray(pArray) Then
   If VerificaArrayInizializzato(pArray) = True Then

      ' Incremento di uno il numero di elementi
         NewArrSize = CInt(UBound(pArray) + 1)
         ReDim Preserve pArray(NewArrSize)
      ' Aggiungo in coda il nuovo elemento (se c' anche il secondo valore lo accodo alla stringa del primoElemento separandolo con "")
         pArray(NewArrSize) = pElement '& " & IIf(Len(Trim(pSecondoElement)) > 0, pSecondoElement, "")"
      
   Else
      ReDim pArray(0)
      pArray(0) = pElement '& " & IIf(Len(Trim(pSecondoElement)) > 0, pSecondoElement, "")"
   End If
   
   AddArrayElement = pArray
   
End Function

Public Function VerificaEsecuzioneEXE(PathExe As String) As Boolean
   Dim bf As Byte
   
   On Error GoTo err

   'Verifico SEMPRE che il file sista altrimenti NON pu essere in esecuzione !!!
   If VerificaEsistenzaFile(PathExe) = False Then
      VerificaEsecuzioneEXE = False
      Exit Function
   End If
   
   Open PathExe For Binary As 1
   Get #1, 1, bf
   Put #1, 1, bf
   Close #1

   On Error GoTo 0
   VerificaEsecuzioneEXE = False
   Exit Function
 
err:
   Close #1
   VerificaEsecuzioneEXE = True
   On Error GoTo 0
End Function


Public Sub PausaProgramma(pSecondi As Integer, _
                          Optional MenoDiUnSecondo As Boolean, Optional pUltraRapido As Boolean)
   Dim vTempoPart As Date
   Dim i As Long
   
   vTempoPart = DateAdd("s", pSecondi, Time)
   Do Until Time > vTempoPart
      DoEvents
      i = i + 1
      
      If pUltraRapido Then If i = 75000 Then Exit Do
      If MenoDiUnSecondo Then If i = 150000 Then Exit Do
   Loop
End Sub



'****CLAUDIA 2018.09.24
'Imposto un max elementi a 50, ciclando sul file di libreria,
'verifico se in esecuzione e in caso di valore true, aggiungo all'array da far restituire alla funzione
Public Function VerificaAppInEsecuzione(pPathLibraryFile As String) As String()

   Dim strVerify_PATH As String
   Dim arrList() As String
   Dim i As Integer

   'ReDim arrList(1 To 50)
   
   For i = 1 To 50
      strVerify_PATH = ReadINI("VERIFY", Trim(Str(i)) & "_FILENAME", pPathLibraryFile)
   
      If Len(Trim(strVerify_PATH)) > 0 Then
         
         strVerify_PATH = tDatiApp.aFolderInstall & "\" & strVerify_PATH
         
         If VerificaEsecuzioneEXE(strVerify_PATH) Then  'file in esecuzione
         
            'se il programma  in esecuzione allora provo a chiuderlo forzatamente
            If Not KillProcess(strVerify_PATH) Then
               'se per qualsiasi motivo non sono riuscita a killarlo,
               'allora lo aggiungo all'elenco
               Call AddArrayElement(arrList, strVerify_PATH)
            End If
            
         End If
         
      Else
         Exit For
      End If
         
   Next i
    
   VerificaAppInEsecuzione = arrList
End Function


Public Function KillProcess(ByVal processName As String) As Boolean

   On Error GoTo ErrHandler
   
   Dim oWMI
   Dim ret
   Dim sService
   Dim oWMIServices
   Dim oWMIService
   Dim oServices
   Dim oService
   Dim servicename
   Dim vFileName   As String
   
   Set oWMI = GetObject("winmgmts:")
   Set oServices = oWMI.InstancesOf("win32_process")
   
   vFileName = FileNameFromPath(processName)
   
   For Each oService In oServices
   
      servicename = LCase(Trim(CStr(oService.Name) & ""))
      
      If InStr(1, servicename, LCase(vFileName), vbTextCompare) > 0 Then
         ret = oService.Terminate
      End If
   Next
   
   Set oServices = Nothing
   Set oWMI = Nothing
   
   KillProcess = IIf(ret = 0, True, False)
   
ErrHandler:
   err.Clear
End Function


Public Function FileNameFromPath(strFullPath As String) As String
     FileNameFromPath = Right(strFullPath, Len(strFullPath) - InStrRev(strFullPath, "\"))
End Function
 

Public Function MnuOpenReleaseNotes() As Boolean
'QUI APRO IL FILE PDF CON LE NOTE DI RELEASE
   Dim vPathVis As String
   
   'Cerco il NUOVO Release Notes .htm
   vPathVis = AppParam.gPrimoRoot & "\Files\Doc\Release Notes.htm"
   If VerificaEsistenzaFile(vPathVis) = True Then
      
      'Qui APRO IL FILE
         If Len(Trim(vPathVis)) > 0 Then Call ShowFILE(FormMAIN, vPathVis)
         MnuOpenReleaseNotes = True
      
   Else
      
      'Non ho trovato il file
         MsgBox "OOPS! C'E' UN PROBLEMA ..." & vbNewLine & "NON TROVO LE 'NOTE della RELEASE'!" & vbNewLine & vbNewLine & _
                "TI CONSIGLIO DI CONTATTARE L'ASSISTENZA", msg_Critical, "", "CHIUDI"

   End If
End Function

Public Sub ShowFILE(pForm As Form, pPathFile As String)
   Dim llSuccess As Variant
   'Dim strPathFile As String

   If Len(Trim(pPathFile)) = 0 Then Exit Sub

   If Len(pPathFile) > 0 Then
      'ApriFax = ShortPathName(ApriFax)
      llSuccess = ShellExecute(pForm.hWnd, "Open", pPathFile, 0&, 0&, SW_SHOWNORMAL)
   End If
End Sub


Public Sub CheckScadenza()
   Dim vGGPreavviso As Integer

   'Controllo se mostare avvisi dell'avvicinarsi della scadenza
   If IsDate(tLicenza.lScadenza) Then
      
      tLicenza.lScadeGG = DateDiff("d", Date, tLicenza.lScadenza)
      'If tLicenza.lScadeGG < 0 Then tLicenza.lScadeGG = 0
      
      If tLicenza.lTipo = eLic_Noleggio Then
         vGGPreavviso = 5
      Else
         vGGPreavviso = 15
      End If
      
      
      'Qui imposto i giorni trascorsi dalla SCADENZA _
       (mi serve per gestire i 30gg extra in cui si pu usufruire del prezzo normale che altrimetni viene aumentato do 200)
      tLicenza.lGGExtraScadenza = (((-30) - (tLicenza.lScadeGG)) * (-1)) 'inverto il Segno in modo che
      
      
      'Verifico se ci sono le condizioni per mostrae l'Avviso _
       Che manchino MENO di 15gg alla scasenza OPPURE se  scaduta che non siano trascorsi pi di 30gg dalla scadenza
      'NB: nel caso siano trascorsi + di 30gg NON faccio comparire pi nulla
      If (tLicenza.lScadeGG <= vGGPreavviso) And (tLicenza.lGGExtraScadenza >= 0) Then
         Call SetAlwaysOnTopMode(FormShowAvviso)
      End If
      
   End If
End Sub


Public Sub CheckNews()

   'Controllo se mostare avvisi dell'avvicinarsi della scadenza
   If IsDate(tNews.From) And IsDate(tNews.To) Then
      'Controllo se OGGI rientra nella data
      If (Date >= CDate(tNews.From)) And (Date <= CDate(tNews.To)) Then
         Call SetAlwaysOnTopMode(FormShowNews)
      End If
   End If
   
End Sub

Public Sub CheckMarketing()

   'Controllo se mostare immagini di marketing
   If VerificaArrayInizializzato(tMarketing.fileJGP) Then
      Call SetAlwaysOnTopMode(FormShowMarketing)
      'Debug.Print "MOSTRA MARKETING"
   End If
   
End Sub



